Rule: Always Use Row-Level Security: "Every single Eloquent query for organization-specific data MUST use the TenantScope. Never write a raw query that forgets the organization_id."

Rule: Meta API Versioning: "All Meta Graph API calls must strictly use v22.0. Do not use older versions or unofficial libraries."

Rule: Error Handling: "Every API call to WhatsApp or OpenAI must be wrapped in a try-catch block that logs errors to a custom meta_errors table for the Admin to see."

Rule: Performance first: "No N+1 queries allowed. Always eager-load relationships for the Chat Inbox and Campaign lists."

Rule: Clean UI: "Strictly follow the color palette #0d203b and #ff3131. Use Tailwind CSS 'Cards' and 'White Space' to keep the dashboard professional."

Zero-Refresh UI: "Use Inertia.js or Livewire with Pessimistic UI updates so that when a user clicks a contact or sends a message, it happens instantly without a full page reload."

Lighthouse Score 95+: "The application must maintain a Google Lighthouse Performance score of 95+. Optimize all assets (JS/CSS) using Vite and use WebP for any image uploads."

Database Indexing: "Message tables will grow to millions of rows. Implement Partitioning or strictly indexed created_at and organization_id columns to ensure 'Load More' buttons never lag."

Dynamic Versioning: Centralize the Meta API version in a config file. All endpoints must be constructed like: config('meta.url') . '/' . config('meta.version') . '/' . $endpoint.

Webhook Versioning: Implement a version check for incoming webhooks. If Meta changes the JSON structure, the system should log the 'Unknown Payload' but not crash.

Scalability: Since I plan to serve 1,000+ clients, use Laravel Queues (Redis) for all message sending. Never send a message during the web request; always push it to a background worker to keep page speed under 200ms.

Timezone Compliance: All campaigns must run in the organization_timezone, never the server's time.

Rule: Real-time Architecture: "Use Laravel Reverb for all WebSockets. Do not use Pusher or any third-party paid broadcasting service. All bulk campaigns must use Laravel Job Batching so the user can see a real-time progress bar powered by Reverb events."

Rule: LLM Gateway Architecture:
- "DO NOT call Gemini, OpenAI, or Claude APIs directly from Controllers or Jobs."
- "All AI interactions MUST go through the `App\Services\AiGateway` service."
- "Use the Laravel 'Manager' pattern to allow switching between providers (Gemini, Claude, GPT) via the `AI_DRIVER` variable in the `.env` file."
- "If using a proxy like LiteLLM, centralize the `BASE_URL` and `API_KEY` in the `config/ai.php` file."
- "The Gateway must support 'Fallback Logic': if the primary model (e.g., Gemini) fails, it must automatically retry with a secondary model (e.g., GPT-4o-mini)."

---
trigger: manual
---

