# Hostinger VPS Deployment Guide (No-Git / Manual Upload)

This guide explains how to deploy your WhatsApp Manager application to a Hostinger VPS by manually uploading files, without using GitHub.

## Prerequisites
- A Hostinger VPS with **Ubuntu 22.04** or **24.04**.
- **CyberPanel** or **CloudPanel** (Recommended for easy management) OR plain terminal access.
- **FileZilla** or **WinSCP** installed on your computer.

---

## Step 1: Prepare Your Application for Production

1. **Build Frontend Assets**:
   Run this command in your local terminal to build the latest assets:
   ```powershell
   npm run build
   ```

2. **Clean Up**:
   Remove `node_modules` folder (it's huge and we will reinstall it on the server).
   Do NOT remove `vendor` folder if you want to save time, but it's better to run `composer install` on the server. For this guide, let's **exclude** `node_modules` and `vendor` to make the upload smaller.

3. **Zip the Project**:
   Select all files in your `WabaManagerApplication` folder **EXCEPT**:
   - `node_modules`
   - `vendor`
   - `.git`
   - `.env` (we will create this on the server)
   
   Right-click -> **Send to** -> **Compressed (zipped) folder**. Name it `wabamanager.zip`.

---

## Step 2: Upload to Hostinger VPS

1. **Connect via SFTP** (using FileZilla/WinSCP):
   - **Host**: Your VPS IP Address
   - **Username**: root (or your sudo user)
   - **Password**: Your VPS password
   - **Port**: 22

2. **Upload**:
   Navigate to `/var/www/html` (or your web server's root directory).
   Create a folder named `wabamanager`.
   Upload `wabamanager.zip` into `/var/www/html/wabamanager`.

3. **Unzip**:
   Open your VPS Terminal (via Hostinger Dashboard or SSH).
   ```bash
   cd /var/www/html/wabamanager
   apt-get install unzip
   unzip wabamanager.zip
   rm wabamanager.zip
   ```

---

## Step 3: Install Dependencies on Server

Run these commands inside `/var/www/html/wabamanager`:

1. **Install PHP Modules** (if not already installed):
   ```bash
   apt install php-bcmath php-curl php-mbstring php-xml php-zip php-mysql
   ```

2. **Install Composer Dependencies**:
   ```bash
   export COMPOSER_ALLOW_SUPERUSER=1
   composer install --optimize-autoloader --no-dev
   ```

3. **Install Node.js Dependencies** (Needed for Reverb/WebSockets):
   ```bash
   curl -fsSL https://deb.nodesource.com/setup_18.x | bash -
   apt-get install -y nodejs
   npm install --omit=dev
   ```

---

## Step 4: Configure Environment & Database

1. **Create .env file**:
   ```bash
   cp .env.example .env
   nano .env
   ```

2. **Edit the .env file**:
   Fill in these critical values:
   ```ini
   APP_ENV=production
   APP_DEBUG=false
   APP_URL=https://your-domain.com

   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_DATABASE=wabamanager
   DB_USERNAME=root
   DB_PASSWORD=your_db_password

   BROADCAST_CONNECTION=reverb
   QUEUE_CONNECTION=database

   # Critical for Webhooks (Incoming Messages)
   META_APP_SECRET=your_meta_app_secret
   META_WEBHOOK_VERIFY_TOKEN=any_random_secure_string
   ```
   *Note: `META_APP_SECRET` is required for security. `WABA_ID` and `TOKEN` will be entered in the dashboard UI.*

3. **Generate Key**:
   ```bash
   php artisan key:generate
   ```

4. **Setup Database**:
   Create the database in MySQL, then run:
   ```bash
   php artisan migrate --force
   ```

5. **Set Permissions**:
   ```bash
   chown -R www-data:www-data /var/www/html/wabamanager
   chmod -R 775 storage bootstrap/cache
   ```

---

## Step 5: Configure Web Server (Nginx)

Create a config file: `/etc/nginx/sites-available/wabamanager`

```nginx
server {
    listen 80;
    server_name your-domain.com;
    root /var/www/html/wabamanager/public;

    add_header X-Frame-Options "SAMEORIGIN";
    add_header X-Content-Type-Options "nosniff";

    index index.php;
    charset utf-8;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location = /favicon.ico { access_log off; log_not_found off; }
    location = /robots.txt  { access_log off; log_not_found off; }

    error_page 404 /index.php;

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.2-fpm.sock; # Adjust PHP version if needed
        fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
        include fastcgi_params;
    }

    # WebSocket Proxy for Chat
    location /app {
        proxy_pass http://127.0.0.1:8080;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection "Upgrade";
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto https;
    }
}
```

Enable it:
```bash
ln -s /etc/nginx/sites-available/wabamanager /etc/nginx/sites-enabled/
nginx -t
systemctl restart nginx
```

**SSL (HTTPS)** is mandatory for WhatsApp:
```bash
apt install certbot python3-certbot-nginx
certbot --nginx -d your-domain.com
```

---

## Step 6: Start Background Workers (Supervisor)

Install Supervisor:
```bash
apt install supervisor
```

Create config `/etc/supervisor/conf.d/wabamanager.conf`:
```ini
[program:waba-worker]
process_name=%(program_name)s_%(process_num)02d
command=php /var/www/html/wabamanager/artisan queue:work --sleep=3 --tries=3
autostart=true
autorestart=true
user=www-data
numprocs=2

[program:waba-reverb]
command=php /var/www/html/wabamanager/artisan reverb:start
autostart=true
autorestart=true
user=www-data
```

Start it:
```bash
supervisorctl reread
supervisorctl update
supervisorctl start all
```

---

## Step 7: Connect WhatsApp (Manual Method)

1. Log in to your new website.
2. Go to **Settings > WhatsApp**.
3. You will see a new **Manual Configuration** box.
4. Enter your:
   - **WABA ID** (From Meta Business Manager)
   - **Phone Number ID** (From Meta Developer Console > WhatsApp > API Setup)
   - **System User Token** (Permanent Token from Business Settings > Users > System Users)
5. Save.

## Step 8: Configure Webhook in Meta

1. Go to developers.facebook.com > Your App > WhatsApp > Configuration.
2. **Callback URL**: `https://your-domain.com/meta/webhook`
3. **Verify Token**: The string you put in `.env` as `META_WEBHOOK_VERIFY_TOKEN`.
4. Click **Verify and Save**.
