<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;

class BillingController extends Controller
{
    /**
     * Show the billing dashboard.
     */
    public function index(Request $request)
    {
        $organization = auth()->user()->organization;
        
        return Inertia::render('Billing/Index', [
            'organization' => $organization,
            'intent' => $organization->createSetupIntent()
        ]);
    }

    /**
     * Handle subscription subscription checkout.
     */
    public function subscribe(Request $request)
    {
        $request->validate([
            'payment_method' => 'required|string',
            'plan' => 'required|string|in:price_basic,price_pro,price_enterprise', // Use real Stripe Price IDs
        ]);

        $organization = auth()->user()->organization;

        try {
            $organization->newSubscription('default', $request->plan)
                ->create($request->payment_method);

            return back()->with('success', 'Successfully subscribed!');
        } catch (\Exception $e) {
            return back()->with('error', $e->getMessage());
        }
    }
}
