<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Group;
use Illuminate\Http\Request;

class GroupController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string'
        ]);

        $existing = Group::where('organization_id', auth()->user()->organization_id)
            ->where('name', $validated['name'])
            ->first();
            
        if ($existing) {
            return back()->withErrors(['name' => 'A group with this name already exists.']);
        }

        Group::create($validated);

        return back()->with('success', 'Group created successfully.');
    }

    public function update(Request $request, Group $group)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string'
        ]);

        $existing = Group::where('organization_id', auth()->user()->organization_id)
            ->where('name', $validated['name'])
            ->where('id', '!=', $group->id)
            ->first();
            
        if ($existing) {
            return back()->withErrors(['name' => 'A group with this name already exists.']);
        }

        $group->update($validated);

        return back()->with('success', 'Group updated successfully.');
    }

    public function destroy(Group $group)
    {
        $group->delete();
        return back()->with('success', 'Group deleted successfully.');
    }
}
