<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Campaign extends BaseTenantModel
{
    use HasFactory;

    protected $fillable = [
        'organization_id',
        'name',
        'template_name',
        'language',
        'components',
        'scheduled_at',
        'status',
        'total_recipients',
        'successful_sends',
        'failed_sends',
    ];

    protected function casts(): array
    {
        return [
            'components' => 'array',
            'scheduled_at' => 'datetime',
        ];
    }

    public function contacts(): BelongsToMany
    {
        return $this->belongsToMany(Contact::class, 'campaign_contacts')
            ->withPivot('status', 'error_message')
            ->withTimestamps();
    }
}
