<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class Group extends BaseTenantModel
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'organization_id',
        'name',
        'description',
    ];

    /**
     * Get the contacts that belong to the group.
     */
    public function contacts()
    {
        return $this->belongsToMany(Contact::class);
    }
}
