<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Laravel\Cashier\Billable;

class Organization extends Model
{
    use Billable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'waba_id',
        'phone_number_id',
        'system_user_token',
        'system_user_token_expires_at',
        'timezone',
        'settings',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'settings' => 'array',
            'system_user_token' => 'encrypted',
            'system_user_token_expires_at' => 'datetime',
        ];
    }

    /**
     * Get the users for the organization.
     */
    public function roles(): HasMany
    {
        return $this->hasMany(OrganizationRole::class);
    }

    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }
}
