<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrganizationRole extends Model
{
    use HasFactory;

    protected $fillable = [
        "organization_id",
        "name",
        "description",
        "permissions",
    ];

    protected $casts = [
        "permissions" => "array",
    ];

    /**
     * Get the organization that owns the role.
     */
    public function organization()
    {
        return $this->belongsTo(Organization::class);
    }

    /**
     * Get the users assigned to this role.
     */
    public function users()
    {
        return $this->hasMany(User::class);
    }
}
