<?php

namespace App\Providers;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;

class TenantServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Intercept broadcasting events to dynamically change the driver
        Event::listen(\Illuminate\Broadcasting\BroadcastEvent::class, function ($event) {
            // Check if organization exists in the container or event
            if (app()->bound('organization')) {
                $organization = app()->make('organization');
                $driver = $organization->broadcast_driver ?? 'reverb';

                if ($driver === 'pusher') {
                    // Pull Pusher credentials from organization settings
                    $settings = $organization->settings ?? [];
                    if (isset($settings['pusher_app_id'])) {
                        Config::set('broadcasting.connections.pusher.key', $settings['pusher_app_key'] ?? '');
                        Config::set('broadcasting.connections.pusher.secret', $settings['pusher_app_secret'] ?? '');
                        Config::set('broadcasting.connections.pusher.app_id', $settings['pusher_app_id']);
                        Config::set('broadcasting.connections.pusher.options.cluster', $settings['pusher_cluster'] ?? 'mt1');
                        Config::set('broadcasting.connections.pusher.options.host', 'api-'.($settings['pusher_cluster'] ?? 'mt1').'.pusher.com');
                        Config::set('broadcasting.connections.pusher.options.port', 443);
                        Config::set('broadcasting.connections.pusher.options.scheme', 'https');
                    }
                    Config::set('broadcasting.default', 'pusher');
                } else {
                    Config::set('broadcasting.default', 'reverb');
                }
            }
        });
    }
}
