<?php

namespace App\Services\Ai;

use Illuminate\Support\Manager;
use App\Services\Ai\Contracts\AiDriverInterface;
use App\Services\Ai\Drivers\OpenAiDriver;
use App\Services\Ai\Drivers\AnthropicDriver;
use App\Services\Ai\Drivers\GoogleDriver;

class AiGateway extends Manager
{
    /**
     * Get the default driver name.
     */
    public function getDefaultDriver(): string
    {
        return $this->config->get('ai.default', 'openai');
    }

    /**
     * Create an instance of the OpenAI driver.
     */
    protected function createOpenaiDriver(): AiDriverInterface
    {
        return new OpenAiDriver(
            $this->config->get('ai.drivers.openai.api_key'),
            $this->config->get('ai.drivers.openai.model', 'gpt-4o')
        );
    }

    /**
     * Create an instance of the Anthropic driver.
     */
    protected function createAnthropicDriver(): AiDriverInterface
    {
        return new AnthropicDriver(
            $this->config->get('ai.drivers.anthropic.api_key'),
            $this->config->get('ai.drivers.anthropic.model', 'claude-3-opus-20240229')
        );
    }

    /**
     * Create an instance of the Google driver.
     */
    protected function createGoogleDriver(): AiDriverInterface
    {
        return new GoogleDriver(
            $this->config->get('ai.drivers.google.api_key'),
            $this->config->get('ai.drivers.google.model', 'gemini-1.5-pro')
        );
    }
}
