<?php

namespace App\Services\Ai\Drivers;

use App\Services\Ai\Contracts\AiDriverInterface;
use OpenAI;
use OpenAI\Client;

class OpenAiDriver implements AiDriverInterface
{
    protected Client $client;
    protected string $model;

    public function __construct(string $apiKey, string $model = 'gpt-4o')
    {
        $this->client = OpenAI::client($apiKey);
        $this->model = $model;
    }

    public function chat(array $messages, array $options = []): string
    {
        $response = $this->client->chat()->create([
            'model' => $options['model'] ?? $this->model,
            'messages' => $messages,
            'max_tokens' => $options['max_tokens'] ?? 1024,
            'temperature' => $options['temperature'] ?? 0.7,
        ]);

        return $response->choices[0]->message->content ?? '';
    }
}
