<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('messages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('organization_id')->constrained()->onDelete('cascade');
            $table->foreignId('contact_id')->constrained()->onDelete('cascade');
            $table->string('meta_message_id')->nullable()->unique();
            $table->enum('direction', ['inbound', 'outbound']);
            $table->string('type')->default('text'); // text, image, audio, video, location, template
            $table->text('content')->nullable();
            $table->string('status')->default('pending'); // pending, sent, delivered, read, failed
            $table->json('media_metadata')->nullable();
            $table->text('error_message')->nullable();
            $table->timestamps();

            // Index for high-volume querying and preventing lag at millions of rows
            $table->index(['organization_id', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('messages');
    }
};
