<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            if (!Schema::hasColumn('contacts', 'phone_number')) {
                $table->string('phone_number')->nullable()->after('phone');
                $table->index(['organization_id', 'phone_number']);
            }

            if (!Schema::hasColumn('contacts', 'last_marketed_at')) {
                $table->timestamp('last_marketed_at')->nullable()->after('last_messaged_at');
            }

            if (!Schema::hasColumn('contacts', 'opted_out')) {
                $table->boolean('opted_out')->default(false)->after('is_opted_out');
            }
        });

        // Backfill the new columns with existing data where possible
        if (Schema::hasColumn('contacts', 'phone') && Schema::hasColumn('contacts', 'phone_number')) {
            DB::table('contacts')->whereNull('phone_number')->update([
                'phone_number' => DB::raw('phone'),
            ]);
        }

        if (Schema::hasColumn('contacts', 'is_opted_out') && Schema::hasColumn('contacts', 'opted_out')) {
            DB::table('contacts')->update([
                'opted_out' => DB::raw('is_opted_out'),
            ]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            if (Schema::hasColumn('contacts', 'opted_out')) {
                $table->dropColumn('opted_out');
            }

            if (Schema::hasColumn('contacts', 'last_marketed_at')) {
                $table->dropColumn('last_marketed_at');
            }

            if (Schema::hasColumn('contacts', 'phone_number')) {
                $table->dropIndex('contacts_organization_id_phone_number_index');
                $table->dropColumn('phone_number');
            }
        });
    }
};
