<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            if (!Schema::hasColumn('contacts', 'gender')) {
                $table->enum('gender', ['male', 'female', 'other'])->nullable()->after('dob');
            }
        });

        // Ensure phone_number is populated for uniqueness enforcement
        DB::table('contacts')
            ->whereNull('phone_number')
            ->update(['phone_number' => DB::raw('phone')]);

        Schema::table('contacts', function (Blueprint $table) {
            // Create a composite index for tenant + phone_number if it does not already exist
            $table->unique(['organization_id', 'phone_number'], 'contacts_org_phone_number_unique');
        });
    }

    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            if (Schema::hasColumn('contacts', 'gender')) {
                $table->dropColumn('gender');
            }

            $table->dropUnique('contacts_org_phone_number_unique');
        });
    }
};
