<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create("organization_roles", function (Blueprint $table) {
            $table->id();
            $table->foreignId("organization_id")->constrained()->cascadeOnDelete();
            $table->string("name");
            $table->string("description")->nullable();
            $table->json("permissions")->nullable(); // Store features/limits allowed for this role
            $table->timestamps();

            // Prevent duplicate role names within the same organization
            $table->unique(["organization_id", "name"]);
        });

        // Add role_id to users table to link to custom roles
        Schema::table("users", function (Blueprint $table) {
            $table->foreignId("organization_role_id")->nullable()->constrained("organization_roles")->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table("users", function (Blueprint $table) {
            $table->dropForeign(["organization_role_id"]);
            $table->dropColumn("organization_role_id");
        });
        
        Schema::dropIfExists("organization_roles");
    }
};
