<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('custom_field_definitions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('organization_id')->constrained()->onDelete('cascade');
            $table->string('key')->unique(); // Field key for storage
            $table->string('label'); // Display label
            $table->enum('type', ['text', 'textarea', 'number', 'date', 'select', 'checkbox', 'email', 'url']);
            $table->boolean('required')->default(false);
            $table->boolean('default_visible')->default(true); // Show in table by default
            $table->integer('sort_order')->default(0); // For drag & drop ordering
            $table->json('options')->nullable(); // For select/checkbox types
            $table->string('default_value')->nullable();
            $table->timestamps();
            
            $table->index(['organization_id', 'sort_order']);
            $table->unique(['organization_id', 'key']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('custom_field_definitions');
    }
};
