<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('contact_notes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('contact_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('organization_id')->constrained()->onDelete('cascade');
            $table->text('content');
            $table->boolean('pinned')->default(false);
            $table->timestamps();

            $table->index(['contact_id', 'created_at']);
            $table->index(['organization_id', 'contact_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('contact_notes');
    }
};
