<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class AdminLoginTest extends TestCase
{
    use RefreshDatabase;

    public function test_admin_can_access_dashboard()
    {
        $admin = User::factory()->create(['role' => 'System_Admin', 'organization_id' => null]);

        $response = $this->actingAs($admin)->get('/admin/dashboard');

        $response->assertStatus(200);
    }

    public function test_admin_redirect_from_login()
    {
        $admin = User::factory()->create(['role' => 'System_Admin', 'organization_id' => null, 'email' => 'superadmin@wabamanager.com']);

        $response = $this->post('/login', [
            'email' => 'superadmin@wabamanager.com',
            'password' => 'password'
        ]);

        $response->assertRedirect('/admin/dashboard');
    }
}
