<?php

namespace Tests\Feature;

use App\Models\Organization;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class UserLoginFlowTest extends TestCase
{
    use RefreshDatabase;

    public function test_tenant_owner_can_access_dashboard()
    {
        $org = Organization::create(['name' => 'Test Org']);
        $owner = User::factory()->create(['role' => 'Owner', 'organization_id' => $org->id]);

        $response = $this->actingAs($owner)->get('/dashboard');

        $response->assertStatus(200);
    }

    public function test_tenant_agent_can_access_dashboard()
    {
        $org = Organization::create(['name' => 'Test Org']);
        $agent = User::factory()->create(['role' => 'Agent', 'organization_id' => $org->id]);

        $response = $this->actingAs($agent)->get('/dashboard');

        $response->assertStatus(200);
    }

    public function test_tenant_owner_redirect_from_login()
    {
        $org = Organization::create(['name' => 'Test Org']);
        $owner = User::factory()->create(['role' => 'Owner', 'organization_id' => $org->id, 'email' => 'owner@democompany.com']);

        $response = $this->post('/login', [
            'email' => 'owner@democompany.com',
            'password' => 'password'
        ]);

        $response->assertRedirect('/dashboard');
    }

    public function test_tenant_agent_redirect_from_login()
    {
        $org = Organization::create(['name' => 'Test Org']);
        $agent = User::factory()->create(['role' => 'Agent', 'organization_id' => $org->id, 'email' => 'agent@democompany.com']);

        $response = $this->post('/login', [
            'email' => 'agent@democompany.com',
            'password' => 'password'
        ]);

        $response->assertRedirect('/dashboard');
    }
}
